<?php

namespace App\Filament\Resources\SalesResource\Pages;

use App\Filament\Resources\SalesResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;

class CreateSales extends CreateRecord
{
    protected static string $resource = SalesResource::class;

    protected function afterCreate(): void
    {
        $sale = $this->record;

        $total = 0;

        foreach ($sale->items as $item) {
            // Kurangi stok
            $inventory = $item->inventory;
            $inventory->increment('stock_out', $item->quantity);
            $inventory->decrement('current_stock', $item->quantity);

            // Tambahkan log
            \App\Models\InventoryLog::create([
                'inventory_id' => $inventory->id,
                'activity_type' => 'Stock Out',
                'reference_type' => 'Sale',
                'reference_id' => $sale->id,
                'quantity' => $item->quantity,
                'note' => 'Penjualan via invoice ' . $sale->invoice_number,
            ]);

            $total += $item->subtotal;
        }

        // Simpan transaksi keuangan
        \App\Models\Transaction::create([
            'transaction_type' => 'Sale',
            'reference_id' => $sale->id,
            'amount' => $total,
            'transaction_date' => $sale->sale_date,
            'note' => 'Penjualan kepada ' . ($sale->customer_name ?? '-'),
        ]);
    }
}
